#include    "stdio.h"
#include    "ctype.h"
#include    "stdlib.h"
#include    "errno.h"
#include    "string.h"

/* Prototypes */
#ifdef 	OPTION2
static BOOL start_fanfare(int *id);
static void stop_fanfare(void);
#endif
#if defined(OPTION0) && !defined(OPTION1)
static void start_acceleration(void);
static void stop_acceleration(void);
#endif
#if !defined(OPTION0) && defined(OPTION1)
static void start_blah_effect();
static void stop_blah_effect();
#endif



/********************************************
*             Imprelemtation                *
********************************************/
int
main(int argc, char **argv)
{
    int         cmd;
    cmd_arg_t   arg;
    int         id_sound = -1;
#ifdef 	OPTION2
    int         id_fanfare = -1;
    BOOL        in_fanfare = FALSE;
#endif

    while(1) {
        cmd = wait_for_command(&arg);
        switch(cmd) {
        case CMD_STARTUP:
#ifdef 	OPTION2 /* special effects special companies */
            in_fanfare = start_fanfare(&id_fanfare);
#elif  OPTION1
            play_wav_sound(&id_sound, WAV_CLICK);
#endif
            if (OK != file_open(&arg)) {
                MessageBox(NULL, "Fail to open", "Error", MB_OK|MB_ICONEXCLAMATION);
            }
            break;
        case CMD_END_WAV:
#ifdef	OPTION2
            if ((TRUE == in_fanfare) && (id_fanfare == arg.id)) {
                stop_fanfare();
                in_fanfare = FALSE;
                id_fanfare = -1;
            }
#endif
            break;
#if defined(OPTION0) && !defined(OPTION1) /* "B" company original feature */
        case CMD_START_ACCELERATOR:
            start_acceleration();
            break;
        case CMD_STOP_ACCELERATOR:
            stop_acceleration();
            break;
#endif
#if !defined(OPTION0) && defined(OPTION1) /* "C" company original feature */
        case CMD_BLAH_EFFECT_ON:
            start_blah_effect();
            break;
        case CMD_BLAH_EFFECT_OFF:
            stop_blah_effect();
            break;
        }
#endif
    }
    return(IO_SUCCESS);
}



/********************************************
*           Individual Feature              *
********************************************/
#ifdef	OPTION2
/* special effects for special companies */
BOOL
start_fanfare(int *id)
{
    BOOL    result = FALSE;

    change_cursor(CURSOR_NOTE);
    if (play_wav_sound(id, WAV_FANFARE)) {  /* start wav sound */
        result = TRUE;
    }
    return(result);
}

void
stop_fanfare(void)
{
    change_cursor(CURSOR_DEFAULT);
}
#endif /* of OPTION2 */

#if defined(OPTION0) && !defined(OPTION1)
/* Acceleration functions                           */
/*   - Accelerate GPU & MPU & SPU                   */
#  if 0
/*   - This is for "B" company only.                */
/*     Do NOT open this feature to oter companies.  */
#  endif
static void
start_acceleration(void)
{
    StartGpuAccelerator();
    StartMpuAccelerator();
    StartSpuAccelerator();
}

static void
stop_acceleration(void)
{
    StopGpuAccelerator();
    StopMpuAccelerator();
    StopSpuAccelerator();
}
#endif /* of !defined(OPTION0) && !defined(OPTION1) */

#if !defined(OPTION0) && defined(OPTION1)
/* Blah-effect functions                            */
#  if 0
/*   - This feature is for "C" company only.        */
/*     Do NOT open this feature to oter companies.  */
#  endif
static void
start_blah_effect(void)
{
    StartMustacheEnhancement();
    EnhancBeard(TRUE);
    HastenTrichogenous(5);
}

static void
stop_blah_effect(void)
{
    StopMustacheEnhancement();
    EnhancBeard(FALSE);
    HastenTrichogenous(0);
}
#endif /* of !defined(OPTION0) && defined(OPTION1) */
